<?php

function gen_server_uuid($argv) {
	$dtas_cfg = null;

	if(count($argv) < 2 ) {
		echo "Not enough parameters\n";
		echo "[Usage]";
		echo "    gen_server_uuid <dtascfg.xml path> <uuid>\n";
		exit(1);
	}

	if(($dtas_cfg = new SimpleXMLElement(file_get_contents($argv[0]))) == FALSE) {
		echo "Failed to load dtascfg.xml\n";
		exit(1);
	}

	// Try connecting database	
	$dbHost = $dtas_cfg->db->host;
	$dbUser = $dtas_cfg->db->username;
	$dbPassword =  $dtas_cfg->db->password;
	if(($dbconn = pg_connect("host=$dbHost dbname=dtasdb port=5432 user=$dbUser password=$dbPassword")) == FALSE) {
		echo "Failed to connect to database\n";
		exit(1);
	}

	$uuid = strtoupper($argv[1]);

	$result = pg_query_params($dbconn, 'DELETE FROM tb_global_setting WHERE key = $1', array('configuration.management_server.uuid'));
	$result = pg_query_params($dbconn, 'INSERT INTO tb_global_setting (key, value) VALUES($1, $2)', array('configuration.management_server.uuid', $uuid));

	pg_close($dbconn);
	exit(0);
}

?>
